# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, Management

class ConsoleConfigMode( Management.MgmtConfigMode ):

   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "console" )

CliSave.GlobalConfigMode.addChildMode( ConsoleConfigMode )
ConsoleConfigMode.addCommandSequence( 'Mgmt.console' )

@CliSave.saver( 'Mgmt::Console::Config', 'mgmt/console/config' )
def saveConsole( consoleConfig, root, sysdbRoot, options ):
   mode = root[ ConsoleConfigMode ].getSingletonInstance()
   cmds = mode[ 'Mgmt.console' ]
   if ( consoleConfig.idleTimeout.timeout !=
        consoleConfig.idleTimeout.defaultTimeout or options.saveAll ):
      # Only need to save timeout if different from default.
      cmds.addCommand( "idle-timeout %s" %
                       ( int(consoleConfig.idleTimeout.timeout / 60 ) ) )

   if consoleConfig.longHostname:
      cmds.addCommand( "login prompt hostname fqdn" )      
   elif options.saveAll:
      cmds.addCommand( "no login prompt hostname fqdn" )
