# Copyright (c) 2006, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'CliSession.config' )

@CliSave.saver( 'Cli::Session::CliConfig', 'cli/session/input/config' )
def saveConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'CliSession.config' ]
   # saveAll = options.saveAll
   # For entity.sessionProcessTimeout, entity.maxSavedSessions, 
   #   rollbackCommitsAutomatically, maxOpenSessions, processPollInterval,
   #   ... hidden commands, if != default or saveAll...
   # For example:
   #if(( entity.sessionProcessTimeout != entity.defaultSessionProcessTimeout ) 
   #   or saveAll ):
   #   cmds.addCommand( ' .... ' )
   #elif saveAll: # not if still hidden
   #   
   convertEditType = { "set" : "set",
                       "del" : "delete" }
   for pathname, debugConfigCollection in entity.debugEntityCopy.iteritems():
      for attrEdit, debugConfig in debugConfigCollection.debugConfig.iteritems():
         cmdString = "debug configuration sessions pathname %s" % pathname
         cmdString += " attribute %s" % attrEdit.attributeName
         cmdString += " %s " % convertEditType.get( attrEdit.editType )
         cmdString += debugConfig.action[ len( "action" ): ]
         cmds.addCommand( cmdString )
   
   for attrEdit, debugTypeConfig in entity.debugPerTypeEntityCopy.iteritems():
      for pathname, action in debugTypeConfig.action.iteritems():
         cmdString = "debug configuration sessions "
         cmdString += "type %s" % attrEdit.attributeType
         cmdString += " attribute %s" % attrEdit.attributeName
         if pathname:
            cmdString += " pathname %s" % pathname
         cmdString += " %s " % convertEditType.get( attrEdit.editType )
         cmdString += action[ len( "action" ): ]
         cmds.addCommand( cmdString )

   saveAll = options.saveAll
   if entity.maxCheckpoints != entity.defaultMaxCheckpoints:
      cmds.addCommand( 'service configuration checkpoint max saved %s' 
                       % entity.maxCheckpoints )
   elif saveAll:
      cmds.addCommand( 'service configuration checkpoint max saved %d' 
                       % entity.maxCheckpoints )
