#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.CloudHaModes import CloudGcpMode, CloudHaGcpMode
from CloudUtil import getHypervisor
import Tracing

t0 = Tracing.trace0
cloudType = getHypervisor()

class CloudGcpConfigMode( CloudGcpMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudGcpMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class CloudHaConfigPeerGcpMode( CloudHaGcpMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudHaGcpMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( CloudGcpConfigMode ) 

CloudGcpConfigMode.addCommandSequence( 'CloudGcp.global' )

@CliSave.saver( 'Cloud::HA::GcpHaConfig', 'cloudha/gcpconfig' )
def saveCloudGcp( config, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   if cloudType != 'GCP':
      t0( 'unsupported platform' )
   toRun = []
   cfg = config.accessConfig
   if cfg:
      if cfg.project:
         toRun.append( 'project %s '% cfg.project )
      elif saveAll:
         toRun.append( 'no project' )
      if cfg.serviceFileLocation:
         toRun.append( 'service-account file %s' % cfg.serviceFileLocation )
      elif saveAll:
         toRun.append( 'no service-account file' )
      if cfg.proxyName:
         toRun.append( 'proxy %s' % cfg.proxyName )
      elif saveAll:
         toRun.append( 'no proxy' )
   elif saveAll:
      assert not toRun
      toRun.append( 'no project' )
      toRun.append( 'no service-account file' ) 
      toRun.append( 'no proxy' )
   if toRun:
      mode = root[ CloudGcpConfigMode ].getOrCreateModeInstance( None )
      cmds = mode[ 'CloudGcp.global' ]
      for c in toRun:
         cmds.addCommand( c )


