#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.CloudHaModes import CloudAzureMode, CloudHaAzureMode
import Tac
from CloudUtil import getHypervisor
import Tracing

t0 = Tracing.trace0
cloudType = getHypervisor()

class CloudAzureConfigMode( CloudAzureMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudAzureMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class CloudHaConfigPeerAzureMode( CloudHaAzureMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudHaAzureMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )


CliSave.GlobalConfigMode.addChildMode( CloudAzureConfigMode ) 

CloudAzureConfigMode.addCommandSequence( 'CloudAzure.global' )

@CliSave.saver( 'Cloud::HA::AzureHaConfig', 'cloudha/azureconfig' )
def saveCloudAzure( config, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   if cloudType != 'Azure':
      t0( 'unsupported platform' )
   toRun = []
   cfg = config.accessConfig
   if cfg:
      if cfg.adEmail:
         assert cfg.subscriptionId and cfg.password
         toRun.append( 'active-directory credential %s subscription-id %s 7 %s'% \
               ( cfg.adEmail, cfg.subscriptionId, cfg.password ) )
      elif saveAll:
         toRun.append( 'no active-directory credential' )
      if cfg.sdkcredFileLocation:
         toRun.append( 'sdk authentication credential-file %s' % \
              cfg.sdkcredFileLocation )
      elif saveAll:
         toRun.append( 'no sdk authentication credential-file' )
      if cfg.proxyName:
         toRun.append( 'proxy %s' % cfg.proxyName )
      elif saveAll:
         toRun.append( 'no proxy' )
   elif saveAll:
      assert not len( toRun )
      toRun.append( 'no active-directory credential' )
      toRun.append( 'no proxy' )
      toRun.append( 'no sdk authentication credential-file' )

   if toRun:
      mode = root[ CloudAzureConfigMode ].getOrCreateModeInstance( None )
      cmds = mode[ 'CloudAzure.global' ]
      for c in toRun:
         cmds.addCommand( c )


