#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.CloudHaModes import CloudAwsMode, CloudHaAwsMode
import Tac
from CloudUtil import getHypervisor
import Tracing

t0 = Tracing.trace0
cloudType = getHypervisor()

class CloudAwsConfigMode( CloudAwsMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudAwsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class CloudHaConfigPeerAwsMode( CloudHaAwsMode, CliSave.Mode ):
   def __init__( self, param ):
      CloudHaAwsMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CliSave.GlobalConfigMode.addChildMode( CloudAwsConfigMode ) 

CloudAwsConfigMode.addCommandSequence( 'CloudAws.global' )

@CliSave.saver( 'Cloud::HA::AwsHaConfig', 'cloudha/awsconfig' )
def saveCloudAws( config, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   if cloudType != 'AWS':
      t0( 'unsupported platform' )
   toRun = []
   cfg = config.accessConfig
   if cfg:
      if cfg.region:
         toRun.append( 'region %s '% cfg.region )
      elif saveAll:
         toRun.append( 'no region' )
      if cfg.accessKey:
         toRun.append( 'access-key-id 7 %s' % cfg.accessKey )
      elif saveAll:
         toRun.append( 'no access-key-id' )
      if cfg.secretAccess:
         toRun.append( 'secret access-key 7 %s' % cfg.secretAccess )
      elif saveAll:
         toRun.append( 'no secret access-key' ) 
      if cfg.proxyName:
         toRun.append( 'proxy %s' % cfg.proxyName )
      elif saveAll:
         toRun.append( 'no proxy' )
   elif saveAll:
      assert not len( toRun )
      toRun.append( 'no proxy' )
      toRun.append( 'no secret access-key' ) 
      toRun.append( 'no region' )
      toRun.append( 'no access-key-id' )
   if toRun:
      mode = root[ CloudAwsConfigMode ].getOrCreateModeInstance( None )
      cmds = mode[ 'CloudAws.global' ]
      for c in toRun:
         cmds.addCommand( c )


