# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Url
import CliSchedulerLib
from CliSchedulerLib import showTechJobName, showTechCliCommand, \
                            showTechIntervalDefault, showTechMaxLogFilesDefault

CliSave.GlobalConfigMode.addCommandSequence( 'CliScheduler.config' )

@CliSave.saver( 'System::CliScheduler::Config', 'sys/clischeduler/config' )
def saveCliScheduler( config, root, sysdbRoot, options ):
   cmds = root[ 'CliScheduler.config' ]
   if showTechJobName not in config.scheduledCli:
      cmds.addCommand( "no schedule %s " %  showTechJobName )

   if options.saveAll:
      cmds.addCommand( "schedule config max-concurrent-jobs %d " \
                         % config.jobsInProgress )
      cmds.addCommand( "%sschedule config prepend-hostname-logfile" \
                         % ( ""if config.prependHostname else "no " ) )
   else:
      if config.jobsInProgress != config.jobsInProgressDefault:
         cmds.addCommand( "schedule config max-concurrent-jobs %d " \
               % config.jobsInProgress )
      if config.prependHostname != config.prependHostnameDefault:
         cmds.addCommand( "no schedule config prepend-hostname-logfile" )

   for jobName in sorted( config.scheduledCli ):
      cliConfig = config.scheduledCli[ jobName ]

      cliCmd = "schedule %s" % cliConfig.name
      if cliConfig.at != CliSchedulerLib.scheduleNow:
         cliCmd += " at %s" % CliSchedulerLib.extractAtFromDateTime(cliConfig.at)
      cliCmd += " interval %s" % cliConfig.interval \
          if cliConfig.interval != CliSchedulerLib.scheduleOnce \
          else " %s" % CliSchedulerLib.scheduleOnceStr
      cliCmd += " timeout %u" % ( cliConfig.timeout / 60 )
      cliCmd += " max-log-files %d" % cliConfig.maxLogFiles

      if cliConfig.verbose == True :
         cliCmd += " logging verbose"

      if cliConfig.logDir and \
         cliConfig.logDir != CliSchedulerLib.logPrefixDefault:
         cliCmd += " loglocation %s" % Url.filenameToUrl( cliConfig.logDir )
       
      cliCmd += " command %s" % cliConfig.cliCommand

      if options.saveAll:
         cmds.addCommand( cliCmd )
      elif cliConfig.name != showTechJobName:
         # CliSave any non show tech jobs
         cmds.addCommand( cliCmd )
      else:
         # CliSave any non default show tech jobs
         if ( cliConfig.cliCommand != showTechCliCommand or 
              cliConfig.interval != showTechIntervalDefault or 
              cliConfig.timeout != CliSchedulerLib.timeoutDefault * 60 or 
              cliConfig.maxLogFiles != showTechMaxLogFilesDefault or 
              cliConfig.logDir != CliSchedulerLib.logPrefixDefault or 
              cliConfig.at != CliSchedulerLib.scheduleNow ) :
            cmds.addCommand( cliCmd )
