# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.CliRelay import (
      CliRelayConfigModeBase,
      ShowCommandConfigModeBase,
   )
from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )

class ClirelayConfigSaveMode( CliRelayConfigModeBase, CliSave.Mode ):
   def __init__( self, param ):
      CliRelayConfigModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

class ShowCommandConfigSaveMode( ShowCommandConfigModeBase, CliSave.Mode ):
   def __init__( self, param ):
      ShowCommandConfigModeBase.__init__( self, param )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( ClirelayConfigSaveMode,
                            after=[ 'cvx' ] )
ClirelayConfigSaveMode.addCommandSequence( 'cliRelay.config' )

ClirelayConfigSaveMode.addChildMode( ShowCommandConfigSaveMode )
                                      
ShowCommandConfigSaveMode.addCommandSequence( 'cliRelay.showCommandConfig' )

def addCommandsToShowCommandConfig( root, switchMac, hostName, cmdId, cmds,
                                    cvxClusterName ):
   mode = root[ CvxConfigMode ].getOrCreateModeInstance( CvxConfigMode.modeName( \
         cvxClusterName ) )
   cliRelayConfigMode = mode[ ClirelayConfigSaveMode ].getOrCreateModeInstance(
         'cvx-cli-relay' )
   showCommandConfigMode = cliRelayConfigMode[ ShowCommandConfigSaveMode 
         ].getOrCreateModeInstance( ( switchMac, hostName, cmdId ) )
   showCommandConfigMode = showCommandConfigMode[ 'cliRelay.showCommandConfig' ]
   for cmd in cmds:
      showCommandConfigMode.addCommand( cmd )

@CliSave.saver( 'CliRelay::CliRelayCvxAgentConfig', 'cliRelay/serviceAgentConfig',
                requireMounts=( controllerConfigPath, ) )
def saveConfig( config, root, sysdbRoot, options, requireMounts ):

   for showCommandKey in config.cliRelayShowCommand:
      cmds = []
      showCmdConfig = config.cliRelayShowCommand[ showCommandKey ]
      cmds.append( "command %s" % showCmdConfig.showCommand ) 
      if showCmdConfig.revision != 1:
         cmds.append( "revision %d" % showCmdConfig.revision )
      elif options.saveAll:
         cmds.append( "revision 1" )
      if showCmdConfig.responseFormat != 'json':
         cmds.append( "response-format %s" % showCmdConfig.responseFormat )
      elif options.saveAll:
         cmds.append( "response-format json" )
      if showCmdConfig.pythonExpression != showCmdConfig.responseFormat:
         lines = [ "python-expression" ]
         saveOutput = CliSave.sanitizedOutput( options, 
               showCmdConfig.pythonExpression ).rstrip( "\n" )
         for line in saveOutput.split('\n'):
            lines.append( line )
         lines.append( "EOF" )
         # in json, make it a single command with embedded <CR> (see BUG170442)
         if options.showJson: 
            cmds.append( "\n".join( lines ) )
         else: 
            for line in lines:
               cmds.append( line )
      elif options.saveAll:
         cmds.append( "python-expression" )
         cmds.append( showCmdConfig.pythonExpression )
         cmds.append( "EOF" )
      
      cvxClusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      addCommandsToShowCommandConfig( root, showCommandKey.switchMac, 
            showCommandKey.hostName, showCommandKey.cmdId, cmds, cvxClusterName )


