# Copyright (c) 2006, 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import operator
import CliSave
from CliMode.Alias import AliasMode

CliSave.GlobalConfigMode.addCommandSequence( 'Cli.config' )

quote = '"{}"'.format

class AliasConfigMode( AliasMode, CliSave.Mode ):
   aliasOrder = {}

   def __init__( self, param ):
      AliasMode.__init__( self, param )
      CliSave.Mode.__init__( self, param )

   def __cmp__( self, other ):
      # This is used to sort the aliases when saving to a config.
      # Regex aliases have order which is stored in `aliasOrder`.
      # Other aliases get -1 for index, so we also compare their name (`param_`).
      return cmp( ( self.aliasOrder.get( self.param_, -1 ), self.param_ ),
                  ( self.aliasOrder.get( other.param_, -1 ), other.param_ ) )

CliSave.GlobalConfigMode.addChildMode( AliasConfigMode, after=[ 'Cli.config' ] )
AliasConfigMode.addCommandSequence( 'Cli.config.alias' )

@CliSave.saver( 'Cli::Config', 'cli/config' )
def saveConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Cli.config' ]
   saveAll = options.saveAll
   if entity.prompt != entity.promptDefault or saveAll:
      cmds.addCommand( 'prompt %s' % entity.prompt )
   # Do not print "no terminal length|width" in "show running all"
   if entity.terminalLengthOverride != entity.terminalLengthOverrideDefault:
      cmds.addCommand( 'terminal length %s' % entity.terminalLengthOverride )
   if entity.terminalWidthOverride != entity.terminalWidthOverrideDefault:
      cmds.addCommand( 'terminal width %s' % entity.terminalWidthOverride )

   if not entity.commandConfirmation:
      cmds.addCommand( 'terminal confirmation disabled' )
   elif saveAll:
      cmds.addCommand( 'no terminal confirmation disabled' )

   if entity.commandsPath:
      cmds = root[ 'Cli.config' ]
      cmds.addCommand( 'alias commands path %s' % entity.commandsPath )
   elif saveAll:
      cmds = root[ 'Cli.config' ]
      cmds.addCommand( 'no alias commands path' )

   if entity.activityLockSyslogMsg:
      cmds = root[ 'Cli.config' ]
      cmds.addCommand( 'activity-lock-monitor' )

   for alias in sorted( entity.alias.itervalues(),
         key=operator.attrgetter( "cmdAlias" ) ):
      commentKey = 'alias-' + alias.cmdAlias
      # We skip empty aliases with no command.
      # Everything is discarded.
      if not alias.originalCmd:
         pass
      # We save one line aliases in the original one-line format.
      # Convert into multi-line alias if there is any comment for a single
      # command alias.
      elif ( ( len( alias.originalCmd ) == 1 ) and
             ( commentKey not in entity.comment ) ):
         cmds = root[ 'Cli.config' ]
         cmds.addCommand( 'alias %s %s' % ( alias.cmdAlias,
                                            alias.originalCmd.values()[ 0 ] ) )
      # Multi-line aliases, we save everything.
      else:
         mode = root[ AliasConfigMode ].getOrCreateModeInstance( alias.cmdAlias )
         cmds = mode[ 'Cli.config.alias' ]
         for seq, oCmd in alias.originalCmd.iteritems():
            cmds.addCommand( '%d %s' % ( seq, oCmd ) )

   # Regex aliases.
   if entity.regexAlias:
      for index, reAlias in sorted( entity.regexAlias.iteritems() ):
         # We want to preseve order from Sysdb,
         # so we store the indices in the save mode.
         AliasConfigMode.aliasOrder[ quote( reAlias.cmdAlias ) ] = index
         if reAlias.originalCmd:
            # We save all regex aliases as multi-line format or we lose order,
            # because some would go in Cli.config, and some in Cli.config.alias.
            alias = quote( reAlias.cmdAlias )
            mode = root[ AliasConfigMode ].getOrCreateModeInstance( alias )
            cmds = mode[ 'Cli.config.alias' ]
            for seq, oCmd in reAlias.originalCmd.iteritems():
               cmds.addCommand( '%d %s' % ( seq, oCmd ) )

@CliSave.saver( 'Cli::Session::CliConfig', 'cli/session/input/config' )
def saveCliSessionConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Cli.config' ]
   saveAll = options.saveAll
   if entity.maxSavedSessions != 1:
      cmds.addCommand( 'service configuration session max completed %s'
                        % entity.maxSavedSessions )
   elif saveAll:
      cmds.addCommand( 'no service configuration session max completed' )
   if entity.maxOpenSessions != 5:
      cmds.addCommand( 'service configuration session max pending %s'
                        % entity.maxOpenSessions )
   elif saveAll:
      cmds.addCommand( 'no service configuration session max pending' )
