# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliMode.BugAlert import BugAlertConfigModeBase
from CliSavePlugin.Controllerdb import ( CvxConfigMode,
                                         controllerConfigPath,
                                         getClusterName )

class BugAlertConfigSaveMode( BugAlertConfigModeBase, CliSave.Mode ):
   def __init__( self, param ):
      BugAlertConfigModeBase.__init__( self )
      CliSave.Mode.__init__( self, param )

CvxConfigMode.addChildMode( BugAlertConfigSaveMode,
                            after=[ 'cvx' ] )
BugAlertConfigSaveMode.addCommandSequence( 'BugAlert.config' )

def addCommandsToBugAlertConfig( root, cmds, cvxClusterName ):
   mode = root[ CvxConfigMode ].getOrCreateModeInstance( 
      CvxConfigMode.modeName( cvxClusterName ) )
   BugAlertConfigMode = mode[ BugAlertConfigSaveMode ].getOrCreateModeInstance(
         'cvx-bug-alert' )
   bugAlertConfigMode = BugAlertConfigMode[ 'BugAlert.config' ]
   for cmd in cmds:
      bugAlertConfigMode.addCommand( cmd )

# Currently BugAlert has no service sepcific config and relies on 
# common service config. In future if we add BugAlert config
# move controller/service/config to requireMounts
@CliSave.saver( 'BugAlert::BugAlertConfig',
                'bugalert/config',
                requireMounts=( controllerConfigPath, ) )
def saveConfig( config, root, sysdbRoot, options, requireMounts ):
   cmds = []

   if config.enabled:
      cmds.append( 'no shutdown' )
   elif options.saveAll:
      cmds.append( 'shutdown' )

   if cmds:
      cvxClusterName = getClusterName( requireMounts[ controllerConfigPath ] )
      addCommandsToBugAlertConfig( root, cmds, cvxClusterName )


