# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave, FileUrl, SimpleConfigFile
import SecretCli

# prefix class name with '000' to make sure it always appears first in show
# running output
CliSave.GlobalConfigMode.addCommandSequence( '000Boot.config' )

# The netconfig arguments being passed here are dummy. Since the boot config is
# not part of Sysdb, to get boot parameters to display as part of the
# running-config, dummy arguments need to be passed to make saver() decorator
# happy
@CliSave.saver( 'System::NetConfig', 'sys/net/config' )
def saveBoot( netConfig, root, sysdbRoot, options ):
   url = FileUrl.localBootConfig( None, True )
   bootConfigFilename = url.realFilename_
   config = SimpleConfigFile.SimpleConfigFileDict( bootConfigFilename )
   cmds = root[ '000Boot.config' ]
   try:
      if "SWI" in config:
         cmds.addCommand( "! boot system %s" % config[ 'SWI' ] )
      if "CONSOLESPEED" in config:
         cmds.addCommand( "! boot console speed %s" % config[ 'CONSOLESPEED' ] )
      if "PASSWORD" in config:
         cmd = "! boot secret "
         hashToken = SecretCli.getHashToken( config[ 'PASSWORD' ] )
         # If we can't parse the password, add an error value. We don't
         # want to break CliSave, but we also want to say that the value is bad.
         if hashToken:
            cmd += hashToken
            cmd += " %s"
            cmds.addCommand( cmd % 
                  CliSave.sanitizedOutput( options, config[ 'PASSWORD' ] ) )
         else:
            cmd += "BAD_PASSWORD"
            cmds.addCommand( cmd )
      if "memtest" in config:
         cmds.addCommand( "! boot test memory %s" % config[ 'memtest' ] )
   except IOError:
      pass
