# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Blackbox.config' )
@CliSave.saver( 'Hardware::Blackbox::CliConfig',
                'hardware/blackbox/cliConfig' )
def saveCpldCliConfig( entity, root, sysdbRoot, options, requireMounts ):
   cmds = root[ 'Blackbox.config' ]
   
   # Note: by default, the feature is enabled
   if entity.enabled:
      if options.saveAll:
         cmds.addCommand( 'hardware console persistent logging' )
   else:
      cmds.addCommand( 'no hardware console persistent logging' )

