#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliSave
from CliSavePlugin.RoutingBgpCliSave import (
      RouterBgpBaseConfigMode,
      showBgpConfigInstanceCallbacks
      )
from RouteMapLib import isAsdotConfigured

def vpnExportMethodConfig( bgpConfig ):
   cmds = []
   if bgpConfig.vpnExportMethodL2Best == bgpConfig.vpnExportMethodL3Best:
      if bgpConfig.vpnExportMethodL2Best != bgpConfig.vpnExportMethodL2BestDefault:
         cmds.append( 'vpn export paths %s' % (
            'best' if bgpConfig.vpnExportMethodL2Best else 'all' ) )
   else:
      if bgpConfig.vpnExportMethodL2Best != bgpConfig.vpnExportMethodL2BestDefault:
         cmds.append( 'vpn layer-2 export paths %s' % (
            'best' if bgpConfig.vpnExportMethodL2Best else 'all' ) )
      if bgpConfig.vpnExportMethodL3Best != bgpConfig.vpnExportMethodL3BestDefault:
         cmds.append( 'vpn layer-3 export paths %s' % (
            'best' if bgpConfig.vpnExportMethodL3Best else 'all' ) )
   return cmds

def showVpnExportMethodConfig( bgpConfig ):
   cmdDict = {}
   cmds = vpnExportMethodConfig( bgpConfig )
   if cmds:
      cmdDict[ None ] = vpnExportMethodConfig( bgpConfig )
   return cmdDict

showBgpConfigInstanceCallbacks.append( showVpnExportMethodConfig )

@CliSave.saver( 'Routing::Bgp::Config', 'routing/bgp/config',
                requireMounts=( 'routing/bgp/asn/config', ) )
def saveVpnExportMethodConfig( bgpConfig, root, sysdbRoot, options, requireMounts ):
   asnConfig = requireMounts[ 'routing/bgp/asn/config' ]
   # If a BGP instance is not configured, do not generate any config
   if bgpConfig.asNumber == 0:
      return

   bgpMode = root[ RouterBgpBaseConfigMode ].getOrCreateModeInstance( (
      bgpConfig.asNumber, isAsdotConfigured( asnConfig ), ) )

   cmds = vpnExportMethodConfig( bgpConfig )

   if cmds:
      for cmd in cmds:
         bgpMode[ 'Bgp.config' ].addCommand( cmd )
