#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
from CliSavePlugin.MrouteCliSave import RouterMulticastAfConfigMode
from CliSavePlugin.MrouteCliSave import getCmdRoot, getCliSaveVersion
from McastCommonCliLib import AddressFamily
from McastCommonCliLib import mcast6RoutingSupported, mcastRoutingSupported
from IpLibConsts import DEFAULT_VRF

RouterMulticastAfConfigMode.addCommandSequence( 'McastSfe.vrf.af.config',
                                                after=[ 'Multicast.vrf.af.config' ] )

@CliSave.saver( 'McastCommon::BessAgentStatus',
                'bess/agentstatus',
                requireMounts=( 'routing/multicast/legacyconfig',
                                'routing6/hardware/status',
                                'routing/hardware/status' ) )

def saveBess( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   multicastLegacyConfig = requireMounts[ 'routing/multicast/legacyconfig' ]
   mcast6Supported = mcast6RoutingSupported(
                                   sysdbRoot,
                                   requireMounts[ 'routing6/hardware/status' ] )
   v6SaveAll = mcast6Supported and saveAll

   mcastSupported = mcastRoutingSupported(
      sysdbRoot,
      requireMounts[ 'routing/hardware/status' ] )

   v4SaveAll = mcastSupported and saveAll

   version = getCliSaveVersion( multicastLegacyConfig.version,
                                v6SaveAll or v4SaveAll )

   if version < multicastLegacyConfig.ipMode:
      return

   if entity.v6Enabled or v6SaveAll:
      cmds = getCmdRoot( root, DEFAULT_VRF, AddressFamily.ipv6,
                         multicastLegacyConfig.ipMode,
                         prefix='McastSfe' )

      if entity.v6Enabled:
         cmds.addCommand( 'software-forwarding sfe' )
      elif v6SaveAll:
         cmds.addCommand( 'software-forwarding kernel' )

   if entity.v4Enabled or v4SaveAll:
      cmds = getCmdRoot( root, DEFAULT_VRF, AddressFamily.ipv4,
                         multicastLegacyConfig.ipMode,
                         'McastSfe' )
      if entity.v4Enabled:
         cmds.addCommand( 'software-forwarding sfe' )
      elif v4SaveAll:
         cmds.addCommand( 'software-forwarding kernel' )
