# Copyright (c) 2008, 2009, 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave

# Sometimes we grep startup-config at startup time to apply certain configuration
# without using the Cli parser, such as root password. Things like banner config
# could disrupt this mechanism or even introduce security holes since it contains
# similar lines. We make sure banner config is low priority. At the same time, 
# those configs that need to be parsed at startup time should use 
# before=[ 'config.priority' ]
CliSave.GlobalConfigMode.addCommandSequence( 'Banner.config', 
                                             after=[ 'config.priority' ] )

@CliSave.saver( 'System::BannerConfig', 'sys/banner/config/cli' )
def saveBanners( bannerConfig, root, sysdbRoot, options ):
   cmds = root[ 'Banner.config' ]
   if bannerConfig.loginBanner:
      lines = [ "banner login" ]
      loginBanner = bannerConfig.loginBanner + "EOF"
      for line in loginBanner.split( "\n" ):
         lines.append( line )
      # in json, make it a single command with embedded <CR> (see BUG170442)
      if options.showJson: 
         cmds.addCommand( "\n".join( lines ) )
      else: 
         for line in lines:
            cmds.addCommand( line )
   elif options.saveAll:
      cmds.addCommand( "no banner login" )
   if bannerConfig.motd:
      lines = [ "banner motd" ]
      motd = bannerConfig.motd + "EOF"
      for line in motd.split( "\n" ):
         lines.append( line )
      # in json, make it a single command with embedded <CR> (see BUG170442)
      if options.showJson: 
         cmds.addCommand( "\n".join( lines ) )
      else: 
         for line in lines:
            cmds.addCommand( line )
   elif options.saveAll:
      cmds.addCommand( "no banner motd" )
