#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'Ale.global' )

@CliSave.saver( 'Ale::PortGroupConfig',
                'hardware/ale/portGroupCliConfig',
                requireMounts = ( 'hardware/ale/portGroup',
                                  'hardware/ale/portGroupCliConfig' ) )
def savePortGroupCliConfig( entityPortGroup, root, sysdbRoot, options,
                              requireMounts ):
   cmds = root[ 'Ale.global' ]
   alePortGroup = requireMounts[ 'hardware/ale/portGroup' ]
   saveAll = options.saveAll
   hwPgCmd = 'hardware port-group'
   # Treat all explicit CLI port group config as non-default.
   for groupName, groupMode in entityPortGroup.config.iteritems():
      cmd = '%s %s select %s' % ( hwPgCmd, groupName, groupMode )
      cmds.addCommand( cmd )
   if saveAll:
      # Add default port groups.
      defaultPortGroups = set( alePortGroup.portGroup ).difference(
         entityPortGroup.config )
      for groupName in sorted( defaultPortGroups ):
         cmd = 'no %s %s' % ( hwPgCmd, groupName )
         cmds.addCommand( cmd )

