#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = () )
def saveGreForwarding( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware forwarding mpls gre-key"
   if entity.greKeyForwarding:
      cmds.addCommand( cmdStr )
   elif saveAll:
      cmds.addCommand( "no " + cmdStr )
