# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliSave

tacHwAclMechanism = Tac.Type( "Acl::HwAclMechanism" )

CliSave.GlobalConfigMode.addCommandSequence( 'AleHalo.global' )

@CliSave.saver( 'Acl::ParamConfig', 'acl/paramconfig' )
def saveAleHaloCliConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'AleHalo.global' ]
   saveDefault = options.saveAllDetail or options.saveAll

   if entity.hwAclMechanism == tacHwAclMechanism.hwAclMechanismAlgoMatch:
      onlyStr = " only" if entity.algoMatchOnly is True else ""
      cmds.addCommand( 'hardware access-list mechanism algomatch' + onlyStr )
   elif entity.hwAclMechanism == tacHwAclMechanism.hwAclMechanismTcam:
      cmds.addCommand( 'hardware access-list mechanism tcam' )
   elif entity.hwAclMechanism == tacHwAclMechanism.hwAclMechanismNone:
      cmds.addCommand( 'hardware access-list mechanism none' )
   elif saveDefault:
      cmds.addCommand( 'no hardware access-list mechanism' )

