#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliSavePlugin.TrafficPolicyCliSave import TrafficPoliciesSaveMode
import CliSave
import Tac

tacMatchOption = Tac.Type( 'PolicyMap::ClassMapMatchOption' )
matchIpAccessGroup = tacMatchOption.matchIpAccessGroup
matchIpv6AccessGroup = tacMatchOption.matchIpv6AccessGroup

class AleCpuPolicySaver( object ):
   def __init__( self, entity, root, sysdbRoot, options, requireMounts ):
      self.entity = entity
      self.root = root
      self.sysdbRoot = sysdbRoot
      self.options = options
      self.trafficPolicy = None
      self.currPolicyName = None
      self.matchRule = None
      self.requireMounts = requireMounts

   # save policy map vrf settings
   def saveCpuVrfConfigAll( self, cpuVrfConfig, policiesMode ):
      # first, create list of the traffic policy names
      cmds = policiesMode[ 'TrafficPolicy.TrafficPolicies' ]

      # create a dict indexed by pmapName with a list of vrfs for each
      pmapDict = {}
      for vrf in cpuVrfConfig.trafficPolicies.keys():
         pmapName = cpuVrfConfig.trafficPolicies[ vrf ]
         if pmapName not in pmapDict:
            pmapDict[ pmapName ] = [ vrf, ]
         else:
            pmapDict[ pmapName ].append( vrf )

      # If there's a pmap with just the default vrf, it has a special syntax
      for pmapName in pmapDict:
         if pmapDict[ pmapName ] == [ 'default' ]:
            cmds.addCommand( "cpu traffic-policy %s" % pmapName )
            del pmapDict[ pmapName ]
            break
      # print out remaining pmaps in sorted order
      pmapList = sorted( list( pmapDict.keys() ) )

      for pmapName in pmapList:
         vrfList = sorted( pmapDict[ pmapName ] )
         outVrf = " vrf %s" % ' '.join( vrfList )
         cmds.addCommand( "cpu traffic-policy %s%s" % ( pmapName, outVrf ) )

   def save( self ):
      cpuVrfConfig = self.entity
      if cpuVrfConfig and cpuVrfConfig.trafficPolicies:
         # we have VRF config, so go to the right mode
         trafficPoliciesMode = \
            self.root[ TrafficPoliciesSaveMode ].getOrCreateModeInstance( None )

         if cpuVrfConfig and cpuVrfConfig.trafficPolicies:
            self.saveCpuVrfConfigAll( cpuVrfConfig, trafficPoliciesMode )

# Save all traffic-policy
@CliSave.saver( 'PolicyMap::VrfConfig', 'trafficPolicies/cpu/vrf' )
def saveConfig( entity, root, sysdbRoot, options, requireMounts ):
   cliDumper = AleCpuPolicySaver( entity, root, sysdbRoot, options, requireMounts )
   cliDumper.save()
