#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

decimalPlaces = 5

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = ( 'routing/hardware/status', ) )
def saveAdjSharing( entity, root, sysdbRoot, options, requireMounts ):

   routingHwStatus = requireMounts[ 'routing/hardware/status' ]

   cmds = root[ 'Ira.routing' ]

   adjCmd = "ip hardware fib next-hop sharing"
   if entity.adjSharing != 'platformDefault':
      if entity.adjSharing == "enabled":
         cmd = adjCmd
      else:
         cmd = "no " + adjCmd
      cmds.addCommand( cmd )
   elif options.saveAll:
      if routingHwStatus.adjSharingDefault:
         cmd = adjCmd
      else:
         cmd = "no " + adjCmd
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = () )
def saveProtectDefaultRoute( entity, root, sysdbRoot, options, requireMounts ):

   if entity.protectDefaultRoute or options.saveAll:
      cmds = root[ 'Ira.routing' ]
      cmd = "ip hardware fib default route protected"
      if entity.protectDefaultRoute:
         cmds.addCommand( cmd )
      else:
         cmds.addCommand( 'no ' + cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = () )
def saveDeletionDelay( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib route delete delay"
   if entity.deletionDelay != entity.defaultDeletionDelay:
      cmd = cmdStr + " " + str( int( entity.deletionDelay ) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )


@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = () )
def saveLinkEventEnabled( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   defaultValue = True
   cmdStr = "ip hardware fib next-hop update event bfd"
   if entity.bfdPeerEventEnabled != defaultValue:
      cmds.addCommand( "no " + cmdStr )
   elif saveAll:
      cmds.addCommand( cmdStr )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts = () )
def saveMaxNumRoutes( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib maximum routes"
   if entity.maxNumRoutes != 0:
      cmd = cmdStr + " " + str( int( entity.maxNumRoutes) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing6::Hardware::Config', 'routing6/hardware/config',
                requireMounts = () )
def saveMaxNumRoutes6( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ipv6 hardware fib maximum routes"
   if entity.maxNumRoutes != 0:
      cmd = cmdStr + " " + str( int( entity.maxNumRoutes ) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveUcmpWeightDeviation( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib next-hop weight-deviation"
   if entity.ucmpWeightDeviation != 0.0:
      cmd = cmdStr + " " + str( round( entity.ucmpWeightDeviation, decimalPlaces ) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveExpandEcmpWeight( entity, root, sysdbRoot, options, requireMounts ):

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib hierarchical next-hop flattening weight-expansion ucmp"
   if entity.hfecExpandEcmpNexthopWeight:
      cmd = cmdStr + " ecmp"
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveMaxAleEcmp( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib next-hop multi-path maximum"
   if entity.maxAleEcmp != entity.maxAleEcmpDefault:
      cmd = cmdStr + " " + str( int( entity.maxAleEcmp ) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveHierarchicalFecsDisabled( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib hierarchical next-hop disabled"
   if entity.hierarchicalFecsDisabled:
      cmd = cmdStr
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveHierarchicalFecsMaxLevel( entity, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib hierarchical next-hop max-level"
   if ( entity.hierarchicalFecsMaxLevel !=
        Tac.Value( "Routing::Hardware::HierarchicalFecsMaxLevel" ).invalid ):
      cmd = cmdStr + " " + str( int( entity.hierarchicalFecsMaxLevel ) )
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveAdjResourceOptimizationDsiabled( entity, root,
                                         sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib next-hop resource optimization disabled"
   if not entity.adjResourceOptimizationEnabled:
      cmd = cmdStr
      cmds.addCommand( cmd )
   elif saveAll:
      cmd = "no " + cmdStr
      cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=( 'routing/hardware/status', ) )
def saveAdjResourceOptimizationThresholds( entity, root,
                                           sysdbRoot, options, requireMounts ):
   routingHwStatus = requireMounts[ 'routing/hardware/status' ]

   saveAll = options.saveAll

   cmds = root[ 'Ira.routing' ]

   cmdStr = "ip hardware fib next-hop resource optimization thresholds"
   if routingHwStatus.adjResourceOptimizationSupported:
      if entity.adjResourceOptimizationThresholds.configured:
         thresholds = entity.adjResourceOptimizationThresholds
         cmd = cmdStr + ' low %d high %d' % ( thresholds.stopOptimizationThreshold,
                                              thresholds.startOptimizationThreshold )
         cmds.addCommand( cmd )
      elif saveAll:
         cmd = "no " + cmdStr
         cmds.addCommand( cmd )

@CliSave.saver( 'Routing::Hardware::Config', 'routing/hardware/config',
                requireMounts=() )
def saveAdjProxy( entity, root, sysdbRoot, options, requireMounts ):
   cmds = root[ 'Ira.routing' ]
   if not entity.adjProxyEnabled:
      cmds.addCommand( "ip hardware fib next-hop proxy disabled" )
