# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, CliSave

CliSave.GlobalConfigMode.addCommandSequence( 'AleCapacity.capacity' )

@CliSave.saver( 'AleCapacity::TableThreshold', 'hardware/capacity/config',
      requireMounts = ( 'hardware/capacity/status', ) )
def saveCapacityThreshold( config, root, sysdbRoot, options, requireMounts ):
   saveAll = options.saveAll
   cmds = root[ 'AleCapacity.capacity' ]

   if requireMounts:
      statusDir = requireMounts[ 'hardware/capacity/status' ]
   else:
      statusDir = sysdbRoot[ 'hardware' ][ 'capacity' ][ 'status' ]

   cmdStr = "hardware capacity alert table "

   for name in sorted( config.threshold ):
      rowName = name.split( '-', 1 )
      if len( rowName ) == 1:
         if config.threshold[ name ] == 0:
            cmds.addCommand( "no " + cmdStr + rowName[ 0 ] )
         else:
            cmds.addCommand( cmdStr + rowName[ 0 ] + " threshold " +
                  str( config.threshold[ name ] ) )
      else:
         if config.threshold[ name ] == 0:
            cmds.addCommand( "no " + cmdStr + rowName[ 0 ] + " feature " +
                  rowName[ 1 ] )
         else:
            cmds.addCommand( cmdStr + rowName[ 0 ] + " feature " + rowName[ 1 ] +
                  " threshold " + str( config.threshold[ name ] ) )

   if saveAll:
      for agentName in sorted( statusDir ):
         if statusDir[ agentName ].tableList == None:
            continue
         featureMapping = statusDir[ agentName ].tableList.featureMapping
         for tableName in sorted( featureMapping ):
            for featureName in sorted( featureMapping[ tableName ].feature ):
               rowName = tableName
               if featureName != '':
                  rowName = '-'.join( [ tableName, featureName ] )

               if rowName not in config.threshold:
                  if featureName == '':
                     cmds.addCommand( "default " + cmdStr + tableName )
                  else:
                     cmds.addCommand( "default " + cmdStr + tableName + " feature " +
                           featureName )
