# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import LauncherLib

CliSave.GlobalConfigMode.addCommandSequence( 'Launcher.agentShutdownConfig' )

@CliSave.saver( 'Launcher::AgentShutdownConfig',
      LauncherLib.agentShutdownConfigDirPath )
def saveAgentShutdownConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Launcher.agentShutdownConfig' ]
   if entity.shutdown:
      cmds.addCommand( 'agent %s shutdown' % entity.name )
   for sliceId in entity.perSliceShutdown:
      if entity.perSliceShutdown[ sliceId ]:
         cmds.addCommand( 'agent %s-%s shutdown' % ( entity.name, sliceId ) )
   for supervisor in entity.perCellShutdown:
      if entity.perCellShutdown[ supervisor ]:
         cmds.addCommand( 'agent %s shutdown supervisor %s' % ( entity.name,
                                                               supervisor ) )
   for cellSlice in entity.perCellSliceShutdown:
      if entity.perCellSliceShutdown[ cellSlice ]:
         cmds.addCommand( 'agent %s-%s shutdown supervisor %s' % ( entity.name,
                                               cellSlice.sliceId, cellSlice.mode ) )
