#!/usr/bin/env python
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Url
import Tac
import operator

CliSave.GlobalConfigMode.addCommandSequence( 'Agent.config' )

@CliSave.saver( 'Agent::GlobalConfigDir', 'agent/config' )
def saveAgentConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Agent.config' ]
   for globalConfig in sorted( entity.agentGlobalConfig.itervalues(),
                               key=operator.attrgetter( 'name' ) ):
      # Trace settings
      if globalConfig.trace != "":
         cmds.addCommand(
               'trace %s setting %s' % ( globalConfig.name,
                                         globalConfig.trace) )
      if globalConfig.tracefile != "":
         # User's command is represented using the filenameToUrl function.
         cmds.addCommand(
               'trace %s filename %s' % ( globalConfig.name,
                                          Url.filenameToUrl( globalConfig.tracefile,
                                                             relativeTo='/tmp' ) ) )
      # Other agent settings
      if globalConfig.environment != "":
         cmds.addCommand(
               'agent %s environment %s' % ( globalConfig.name,
                                             globalConfig.environment) )

@CliSave.saver( "Stage::FatalErrorGlobalConfig", "fatalError/config/globalConfig" )
def saveFatalErrorGlobalConfig( entity, root, sysdbRoot, options ):
   #-------------------------------------------------------------------------
   # save config for non-default action only:
   #    agent fatal-error action ignore
   #-------------------------------------------------------------------------
   cmds = root[ "Agent.config" ]
   fatalErrorAction = Tac.Type( "Stage::FatalErrorGlobalConfig::Action" )
   if entity.action != fatalErrorAction.reload:
      cmds.addCommand( "agent fatal-error action %s" % entity.action )
   elif options.saveAll or options.saveAllDetail:
      cmds.addCommand( "agent fatal-error action %s" % entity.action )

CliSave.GlobalConfigMode.addCommandSequence( 'Agent.globalStartupConfig' )

@CliSave.saver( 'Agent::GlobalStartupConfig', 'agent/globalStartupConfig' )
def saveAgentStartupConfig( entity, root, sysdbRoot, options ):
   cmds = root[ 'Agent.globalStartupConfig' ]
   for startupConfig in sorted( entity.agentStartupConfig.itervalues(),
                                key=operator.attrgetter( 'name' ) ):
      if startupConfig.hitlessRestartWindow == 0:
         cmds.addCommand( 'agent %s warm-restart always' % startupConfig.name )
      elif startupConfig.allowedHitlessRestarts == 0:
         cmds.addCommand( 'no agent %s warm-restart' % startupConfig.name )
      else:
         cmds.addCommand( 'agent %s warm-restart window %s'
               % ( startupConfig.name, startupConfig.hitlessRestartWindow ) )
         cmds.addCommand( 'agent %s warm-restart allowed %s'
               % ( startupConfig.name, startupConfig.allowedHitlessRestarts ) )
