# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from IntfCliSave import IntfConfigMode
from AclCliSave import IpAclConfigMode
import CliSave

CliSave.GlobalConfigMode.addCommandSequence( "Aegis.intf",
                                             after=[ IpAclConfigMode ] )
IntfConfigMode.addCommandSequence( "Aegis.intf" )

CliSave.GlobalConfigMode.addCommandSequence( "Aegis.intfEgress",
                                             after=[ IpAclConfigMode ] )
IntfConfigMode.addCommandSequence( "Aegis.intfEgress" )

@CliSave.saver( "PolicyMap::IntfConfig", "trafficPolicies/intf/input/aegis" )
def saveAegisIntfConfigIngress( entity, root, sysdbRoot, options, requireMounts ):
   if entity is None:
      return
   for intf, policyName in entity.intf.iteritems():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ "Aegis.intf" ]
      cmds.addCommand( "traffic-policy input %s" % policyName )

@CliSave.saver( "PolicyMap::IntfConfig", "trafficPolicies/intf/output/aegis" )
def saveAegisIntfConfigEgress( entity, root, sysdbRoot, options, requireMounts ):
   if entity is None:
      return
   for intf, policyName in entity.intf.iteritems():
      mode = root[ IntfConfigMode ].getOrCreateModeInstance( intf )
      cmds = mode[ "Aegis.intfEgress" ]
      cmds.addCommand( "traffic-policy output %s" % policyName )
