# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliSave
import Management
import Tac
from CliMode.Accounts import AccountsUserMode

class AccountsConfigMode( Management.MgmtConfigMode ):
   def __init__( self, param ):
      Management.MgmtConfigMode.__init__( self, "accounts" )

class UserConfigMode( AccountsUserMode, CliSave.Mode ):
   def __init__( self, param ):
      AccountsUserMode.__init__( self, param )
      CliSave.Mode.__init__( self, self.longModeKey )

CliSave.GlobalConfigMode.addChildMode( AccountsConfigMode )
AccountsConfigMode.addCommandSequence( 'Mgmt.accounts' )

AccountsConfigMode.addChildMode( UserConfigMode )
UserConfigMode.addCommandSequence( 'Mgmt.accounts.account' )

sessionLimitType = Tac.Type( "Mgmt::Account::SessionLimit" )
unlimitedSessionLimit = sessionLimitType.unlimited
useGlobalSessionLimit = sessionLimitType.useGlobal

@CliSave.saver( 'Mgmt::Account::Config', 'mgmt/acct/config' )
def saveAccountsConfig( accountsConfig, root, sysdbRoot, options ): 
   mode = root[ AccountsConfigMode ].getSingletonInstance()
   cmds = mode[ 'Mgmt.accounts' ]

   if ( accountsConfig.sessionLimitGlobal !=
        accountsConfig.sessionLimitGlobalDefault ):
      cmds.addCommand( "session default-limit %s" % 
                       accountsConfig.sessionLimitGlobal )
   elif options.saveAll:
      cmds.addCommand( "no session default-limit" )

   for account in sorted( accountsConfig.account.values() ):
      userMode = mode[ UserConfigMode ].getOrCreateModeInstance( account.name )
      cmds = userMode[ 'Mgmt.accounts.account' ] 
      if account.sessionLimit != useGlobalSessionLimit:
         if account.sessionLimit == unlimitedSessionLimit:
            cmds.addCommand( "no session limit" )
         else:
            cmds.addCommand( "session limit %s" % ( account.sessionLimit ) )
