# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, Tracing

t0 = Tracing.trace0

class CliRelayFromCvxReactor( Tac.Notifiee ):
   ''' CVX publish mount appear under the Tac::Dir which the switch agent mounts
   from Sysdb. We care about two entries which correspond the config and
   commandRequest. commandRequest contains the show command requests which switch 
   agent must service. This is a base class and derived classes are implemented in 
   CliRelay switch agent for handling *commandRequest* attribute updates. 
   Derived classes should override handleKey method to implement their
   respective handling on entries under cliRelay/fromCvx mount point.
   '''

   notifierTypeName = 'Tac::Dir'
   def __init__( self, fromCvx ):
      Tac.Notifiee.__init__( self, fromCvx )
      self.fromCvx = fromCvx

      t0( "handleInitialized" )
      for key in self.notifier().entityPtr:
         self.handleFromCvx( key )
   
   def handleKey( self, key, created ):
      assert False, "Not implemented error"

   @Tac.handler( 'entityPtr' )
   def handleFromCvx( self, key ):
      if( key in self.notifier().entityPtr ) and \
            ( self.notifier().entityPtr[ key ] ):
         t0( "handleFromCvx", key, "added" )
         created = True
      else:
         created = False

      self.handleKey( key, created )
