#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.Xmpp as Xmpp
from CliPlugin.XmppModel import Neighbors, XmppStatus, Groups

matcherXmpp = CliMatcher.KeywordMatcher( 'xmpp', helpdesc='Show XMPP status' )

#--------------------------------------------------------------------------------
# show xmpp neighbors
#--------------------------------------------------------------------------------
class XmppNeighborsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show xmpp neighbors'
   data = {
      'xmpp': matcherXmpp,
      'neighbors': 'Show the status of XMPP neighbors',
   }
   handler = Xmpp.showXmppNeighbors
   cliModel = Neighbors

BasicCli.addShowCommandClass( XmppNeighborsCmd )

#--------------------------------------------------------------------------------
# show xmpp status
#--------------------------------------------------------------------------------
class XmppStatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show xmpp status'
   data = {
      'xmpp': matcherXmpp,
      'status': 'Show XMPP status',
   }
   handler = Xmpp.showXmppStatus
   cliModel = XmppStatus

BasicCli.addShowCommandClass( XmppStatusCmd )

#--------------------------------------------------------------------------------
# show xmpp switch-group
#--------------------------------------------------------------------------------
class XmppSwitchGroupCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show xmpp switch-group'
   data = {
      'xmpp': matcherXmpp,
      'switch-group': 'Configure switch-groups to join',
   }
   handler = Xmpp.showXmppGroup
   cliModel = Groups

BasicCli.addShowCommandClass( XmppSwitchGroupCmd )
