#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.Xmpp as Xmpp
import CliPlugin.ConfigMgmtMode

#--------------------------------------------------------------------------------
# [ no | default ] management xmpp
#--------------------------------------------------------------------------------
class ManagementXmppCmd( CliCommand.CliCommandClass ):
   syntax = 'management xmpp'
   noOrDefaultSyntax = 'management xmpp'
   data = {
      'management': CliPlugin.ConfigMgmtMode.managementKwMatcher,
      'xmpp': 'Configure XMPP',
   }
   handler = Xmpp.gotoXmppConfigMode
   noOrDefaultHandler = Xmpp.noXmppConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementXmppCmd )
