#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.Xmpp as Xmpp

matcherSend = CliMatcher.KeywordMatcher( 'send',
      helpdesc='Send XMPP messages or commands' )
matcherXmpp = CliMatcher.KeywordMatcher( 'xmpp', helpdesc='XMPP client commands' )
# Use a DynamicNameRule to allow completions to be provided from neighbors and
# switch-groups, while allowing any JID to be used.
jidMatcher = CliMatcher.DynamicNameMatcher( Xmpp.neighborsAndGroups,
   'Destination XMPP Jabber ID (JID)',
   pattern=r'[^\s]+' )

#--------------------------------------------------------------------------------
# xmpp send JID command COMMAND
#--------------------------------------------------------------------------------
class XmppSendCommandCmd( CliCommand.CliCommandClass ):
   syntax = 'xmpp send JID command COMMAND'
   data = {
      'xmpp': matcherXmpp,
      'send': matcherSend,
      'JID': jidMatcher,
      'command': 'Send a CLI command to a neighbor',
      'COMMAND': CliMatcher.StringMatcher( helpdesc='XMPP command',
         helpname='WORD' ),
   }
   handler = Xmpp.sendXmppCommand

BasicCliModes.EnableMode.addCommandClass( XmppSendCommandCmd )

#--------------------------------------------------------------------------------
# xmpp send JID message MESSAGE
#--------------------------------------------------------------------------------
class XmppSendMessageCmd( CliCommand.CliCommandClass ):
   syntax = 'xmpp send JID message MESSAGE'
   data = {
      'xmpp': matcherXmpp,
      'send': matcherSend,
      'JID': jidMatcher,
      'message': 'Message text to send to the recipient',
      'MESSAGE': CliMatcher.StringMatcher( helpdesc='XMPP message',
         helpname='WORD' ),
   }
   handler = Xmpp.sendXmppMessage

BasicCliModes.EnableMode.addCommandClass( XmppSendMessageCmd )

#--------------------------------------------------------------------------------
# xmpp session JID
#--------------------------------------------------------------------------------
class XmppSession( CliCommand.CliCommandClass ):
   syntax = 'xmpp session JID'
   data = {
      'xmpp': matcherXmpp,
      'session': 'Session to a switch-group over XMPP',
      'JID': jidMatcher,
   }
   handler = Xmpp.xmppSession

BasicCliModes.EnableMode.addCommandClass( XmppSession )

