#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.BridgingCli as BridgingCli
import CliPlugin.VxlanCli as VxlanCli
import CliPlugin.VlanCli as VlanCli
from CliToken.Clear import clearKwNode

counterKwMatcher = CliMatcher.KeywordMatcher( 'counters',
      helpdesc='VXLAN Counters' )

#--------------------------------------------------------------------------------
# clear ( ( mac address-table ) | mac-address-table ) dynamic [ vlan VLANID ]
#    interface VXLANINTF
#--------------------------------------------------------------------------------
class ClearMacAddressTableDynamicVxlanCmd( CliCommand.CliCommandClass ):
   syntax = 'clear MAC_ADDR_TABLE dynamic [ vlan VLANID ] interface VXLANINTF'
   data = {
      'clear': clearKwNode,
      'MAC_ADDR_TABLE': BridgingCli.MacAddrTableExprForClear,
      'dynamic': 'Dynamic entries',
      'vlan': 'Per VLAN',
      'VLANID': VlanCli.vlanIdMatcher,
      'interface': BridgingCli.matcherInterface,
      'VXLANINTF': VxlanCli.VxlanIntf.matcher,
   }
   handler = BridgingCli.doMacAddressTableClear

BasicCliModes.EnableMode.addCommandClass( ClearMacAddressTableDynamicVxlanCmd )

#--------------------------------------------------------------------------------
# clear vxlan counters software
#--------------------------------------------------------------------------------
class ClearVxlanCountersSoftwareCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vxlan counters software'
   data = {
      'clear': clearKwNode,
      'vxlan': VxlanCli.vxlanNode,
      'counters': counterKwMatcher,
      'software': 'Software forwarding counters',
   }
   handler = VxlanCli.clearSwCounters

BasicCliModes.EnableMode.addCommandClass( ClearVxlanCountersSoftwareCmd )

#--------------------------------------------------------------------------------
# clear vxlan counters varp
#--------------------------------------------------------------------------------
class ClearVxlanCountersVarpCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vxlan counters varp'
   data = {
      'clear': clearKwNode,
      'vxlan': VxlanCli.vxlanNode,
      'counters': counterKwMatcher,
      'varp': 'Virtual ARP',
   }
   handler = VxlanCli.clearVarpCounters

BasicCliModes.EnableMode.addCommandClass( ClearVxlanCountersVarpCmd )

#--------------------------------------------------------------------------------
# clear vxlan counters vni [ VNI ]
#--------------------------------------------------------------------------------
class ClearVxlanCountersVniCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vxlan counters vni [ VNI ]'
   data = {
      'clear': clearKwNode,
      'vxlan': VxlanCli.vxlanNode,
      'counters': counterKwMatcher,
      'vni': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'vni', helpdesc='VNI counters' ),
         guard=VxlanCli.vniCountersSupported ),
      'VNI': VxlanCli.vniMatcher,
   }
   handler = VxlanCli.clearVniCounters

BasicCliModes.EnableMode.addCommandClass( ClearVxlanCountersVniCmd )

#--------------------------------------------------------------------------------
# clear vxlan counters vtep [ unlearnt | VTEP ]
#--------------------------------------------------------------------------------
class ClearVxlanCountersVtepCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vxlan counters vtep [ unlearnt | VTEP ]'
   data = {
      'clear': clearKwNode,
      'vxlan': VxlanCli.vxlanNode,
      'counters': counterKwMatcher,
      'vtep': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'vtep', helpdesc='VTEP counters' ),
         guard=VxlanCli.vtepCountersSupported ),
      'unlearnt': 'Unlearnt VTEPs',
      'VTEP': VxlanCli.vtepAddrNode,
   }
   handler = VxlanCli.clearVtepCounters

BasicCliModes.EnableMode.addCommandClass( ClearVxlanCountersVtepCmd )
