#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.MarginCli as MarginCli
from CliToken.Hardware import (
      hardwareMatcherForExec,
)

#--------------------------------------------------------------------------------
# [ no | default ] hardware margin FRU MARGINSOURCE SOURCEID RAILID \
#     ( nominal | ( high | low ) MARGINPERCENT )
#--------------------------------------------------------------------------------
class HardwareMarginCmd( CliCommand.CliCommandClass ):
   syntax = '''hardware margin FRU MARGIN SOURCEID RAILID
            ( nominal | ( ( high | low ) PERCENT ) )'''
   noOrDefaultSyntax = 'hardware margin [ FRU MARGIN SOURCEID RAILID ] ...'
   data = {
      'hardware' : hardwareMatcherForExec,
      'margin' : 'Margin voltage rail to specified percentage',
      'FRU' : MarginCli.systemMatcher,
      'MARGIN' : MarginCli.sourceMatcher,
      'SOURCEID' : MarginCli.sourceIdMatcher,
      'RAILID' :  MarginCli.RailIdMatcher( MarginCli.systemMatcher,
                                           MarginCli.sourceMatcher,
                                           MarginCli.sourceIdMatcher ),
      'nominal' : 'Margin a voltage rail nominal',
      'high' : 'Margin a voltage rail high',
      'low' : 'Margin a voltage rail low',
      'PERCENT' : CliMatcher.FloatMatcher(
         0, 100,
         helpdesc='Margin a voltage rail some percentage (e.g. 5)',
         precisionString='%.25g' ),
   }

   handler = MarginCli.doSetMargin
   noOrDefaultHandler = MarginCli.noSetMargin

BasicCliModes.EnableMode.addCommandClass( HardwareMarginCmd )
