#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.RouteMapCli as RouteMapCli
import CliPlugin.VrfCli as VrfCli
import CliPlugin.VrfLeakCli as VrfLeakCli

#--------------------------------------------------------------------------------
# ( no | default ) leak routes source-vrf VRFNAME subscribe-policy MAPNAME
#--------------------------------------------------------------------------------
class ConfigureVrfLeakCmd( CliCommand.CliCommandClass ):
   syntax = 'leak routes source-vrf VRFNAME subscribe-policy MAPNAME'
   noOrDefaultSyntax = 'leak routes source-vrf VRFNAME ...'
   data = {
      'leak': 'Configure VRF leaking policy',
      'routes': 'Configure VRF route leaking policy',
      'source-vrf': 'Specify the VRF to leak routes from',
      'VRFNAME': VrfCli.vrfMatcher,
      'subscribe-policy': 'Route map to select leaked routes',
      'MAPNAME': RouteMapCli.mapNameMatcher
   }

   handler = VrfLeakCli.VrfLeakModelet.configureVrfLeak
   noOrDefaultHandler = VrfLeakCli.VrfLeakModelet.noVrfLeak

VrfLeakCli.VrfLeakModelet.addCommandClass( ConfigureVrfLeakCmd )
