#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.VrfLeakCli as VrfLeakCli
import CliToken.Clear

#--------------------------------------------------------------------------------
# clear vrf leak flapping
#--------------------------------------------------------------------------------
class ClearVrfLeakFlappingCmd( CliCommand.CliCommandClass ):
   syntax = 'clear vrf leak flapping'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'vrf': 'Clear VRF state',
      'leak': 'Clear VRF leaking state',
      'flapping': 'Clear flapping prefixes',
   }

   handler = VrfLeakCli.clearFlapping

BasicCliModes.EnableMode.addCommandClass( ClearVrfLeakFlappingCmd )
