#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliPlugin.VmTracerCli as VmTracerCli

from ReversibleSecretCli import reversibleAuthPasswordExpression

matcherUrl = CliMatcher.KeywordMatcher( 'url',
      helpdesc='URL of VMware vShield instance to connect to' )
matcherUsername = CliMatcher.KeywordMatcher( 'username',
      helpdesc='Login username for vShield instance' )

#--------------------------------------------------------------------------------
# [ no | default ] password PASSWORD 
#--------------------------------------------------------------------------------
class PasswordCmd( CliCommand.CliCommandClass ):
   syntax = 'password PASSWORD'
   noOrDefaultSyntax = 'password ...'
   data = {
      'password' : 'Login password for vShield instance',
      'PASSWORD' : reversibleAuthPasswordExpression( 'PASSWORD',
                   unencryptedName='TEXT', encryptedName='PWD' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setPassword
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noPassword

VmTracerCli.VShieldConfigMode.addCommandClass( PasswordCmd )

#--------------------------------------------------------------------------------
# url URL
# ( no | default ) url ...
#--------------------------------------------------------------------------------
class UrlUrlCmd( CliCommand.CliCommandClass ):
   syntax = 'url URL'
   noOrDefaultSyntax = 'url ...'
   data = {
      'url' : matcherUrl,
      'URL' : CliMatcher.PatternMatcher( pattern='.+',
              helpdesc='URL of vShield', helpname='url' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setUrl
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noUrl

VmTracerCli.VShieldConfigMode.addCommandClass( UrlUrlCmd )

#--------------------------------------------------------------------------------
# username USERNAME
# ( no | default ) username ...
#--------------------------------------------------------------------------------
class UsernameUsernameCmd( CliCommand.CliCommandClass ):
   syntax = 'username USERNAME'
   noOrDefaultSyntax = 'username ...'
   data = {
      'username' : matcherUsername,
      'USERNAME' : CliMatcher.PatternMatcher( pattern='.+',
                   helpdesc='Username to login to vShield', helpname='username' ),
   }

   handler = VmTracerCli.VShieldConfigMode.setUsername
   noOrDefaultHandler = VmTracerCli.VShieldConfigMode.noUsername

VmTracerCli.VShieldConfigMode.addCommandClass( UsernameUsernameCmd )
