#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliPlugin.VmTracerIntfCli as VmTracerIntfCli

#--------------------------------------------------------------------------------
# [ no | default ] vmtracer vmware-esx
#--------------------------------------------------------------------------------
class VmtracerVmwareEsxCmd( CliCommand.CliCommandClass ):
   syntax = 'vmtracer vmware-esx'
   noOrDefaultSyntax = syntax
   data = {
      'vmtracer' : CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'vmtracer',
      helpdesc='Enable VmTracer on this interface' ),
      guard=VmTracerIntfCli.vmTracerSupportedGuard ),
      'vmware-esx' : 'Vmware-ESX host connected to this interface',
   }

   @staticmethod
   def handler( mode, args ):
      VmTracerIntfCli.enableVmTracer( mode, args.get( 'HOST' ), no=None )

   @staticmethod
   def noOrDefaultHandler ( mode, args ):
      VmTracerIntfCli.enableVmTracer( mode, args.get( 'HOST' ), no=True )

VmTracerIntfCli.VmTracerModelet.addCommandClass( VmtracerVmwareEsxCmd )
