#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.VmTracerCli as VmTracerCli

matcherSession = CliMatcher.KeywordMatcher( 'session',
      helpdesc='Session parameters for VmTracer session' )
matcherVmtracer = CliMatcher.KeywordMatcher( 'vmtracer',
      helpdesc='Configure VmTracer session' )
nodeVmtracer = CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'vmtracer',
      helpdesc='Configure VmTracer session' ),
      guard=VmTracerCli.vmTracerSupportedGuard )

#--------------------------------------------------------------------------------
# [ no | default ] vmtracer session SESSION
# ( no | default ) vmtracer session SESSION vxlan
#--------------------------------------------------------------------------------
class VmtracerSessionVmtracernameCmd( CliCommand.CliCommandClass ):
   # This is merged syntax from two commands:
   # ( no | default ) vmtracer session SESSION vxlan : deletes only configurations
   # of session's vShield/NSX component
   # [ no | default ] vmtracer session SESSION : initialize or delete configuration
   # of the whole VmTracer session
   syntax = 'vmtracer session SESSION'
   noOrDefaultSyntax = 'vmtracer session SESSION [ vxlan ]'
   data = {
      'vmtracer' : nodeVmtracer,
      'session' : 'Session parameters for VmTracer session',
      'SESSION' : CliMatcher.PatternMatcher( pattern='[A-Za-z0-9_-]+',
                  helpdesc='VmTracer session name', helpname='WORD' ),
      'vxlan' : 'Session parameters for vShield or NSX component',
   }

   handler = VmTracerCli.gotoVCenterMode
   noOrDefaultHandler = VmTracerCli.delVmTracerSession

BasicCliModes.GlobalConfigMode.addCommandClass( VmtracerSessionVmtracernameCmd )
