# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""This module implement the CLI for TWAMP server configuration.

In "configuration / monitor connectivity / twamp" mode:
-  [no|default] server
"""

from __future__ import absolute_import, print_function, division

import CliCommand
import ConfigMount
import Toggles.TwampToggleLib as TwampToggle
from CliPlugin.TwampConfigCli import TwampMode

# pkgdeps: rpmwith %{_libdir}/preinit/Twamp

twampControlConfig = None

# CLI command implementations.

#------------------------------------------------------------------------------------
# (mc-twamp)# [no | default] server
#------------------------------------------------------------------------------------
class TwampServer( CliCommand.CliCommandClass ):
   syntax = 'server'
   noOrDefaultSyntax = 'server ...'
   data = {
      'server': 'Enable TWAMP Server and Session-Reflector',
   }

   @staticmethod
   def handler( mode, args ):
      twampControlConfig.enabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      twampControlConfig.enabled = False

if TwampToggle.toggleTwampServerEnabled():
   TwampMode.addCommandClass( TwampServer )

def Plugin( entityManager ):
   global twampControlConfig
   twampControlConfig = ConfigMount.mount(
      entityManager,
      'connectivityMonitor/twamp/control/config',
      'Twamp::Control::Config',
      'w' )
