# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""This module implement the TWAMP CLI configuration mode.

In "configuration / monitor connectivity " mode:
-  [no|default] twamp
"""

from __future__ import absolute_import, print_function, division

import BasicCli
import CliParser
import CliCommand
from CliPlugin.ConnectivityMonitorCli import ConnMonitorConfigMode
from CliMode.Twamp import TwampModeBase

import Toggles.TwampToggleLib as TwampToggle

# CLI command implementations.

#------------------------------------------------------------------------------------
# twamp mode
#------------------------------------------------------------------------------------
class TwampMode( TwampModeBase, BasicCli.ConfigModeBase ):
   name = "TWAMP configuration"
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      TwampModeBase.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

#------------------------------------------------------------------------------------
# (config-mon-connectivity)# [no | default] twamp
#------------------------------------------------------------------------------------
class Twamp( CliCommand.CliCommandClass ):
   syntax = 'twamp'
   noOrDefaultSyntax = 'twamp ...'
   data = {
      'twamp': 'Configure TWAMP settings',
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( TwampMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      pass

if TwampToggle.toggleTwampClientEnabled() or TwampToggle.toggleTwampServerEnabled():
   ConnMonitorConfigMode.addCommandClass( Twamp )
