#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import CliPlugin.TechSupportCli

#-------------------------------------------------------------------------------
# Traffic Policy commands in 'show tech-support'
#-------------------------------------------------------------------------------
statusDir = None

def _trafficPolicyShowTechCmds():
   if statusDir and statusDir.get( 'sand' ):
      return [ 'show traffic-policy cpu',
               'show traffic-policy cpu errors',
               'show traffic-policy protocol neighbors bgp',
               # Use -n to prevent potentially slow DNS lookups.
               'bash sudo iptables -vnL -t mangle',
               'bash sudo ip6tables -vnL -t mangle',
             ]
   return []

def _trafficPolicyInterfaceShowTechCmds():
   if statusDir and statusDir.get( 'sandAegis' ):
      return [ 'show traffic-policy interface',
               'show traffic-policy interface errors',
             ]
   return []

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      '2019-02-26 11:06:03', _trafficPolicyShowTechCmds )

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      '2019-12-05 13:42:17', _trafficPolicyInterfaceShowTechCmds )

def Plugin( entityManager ):
   global statusDir
   statusDirPath = 'cell/%d/trafficPolicies/status' % Cell.cellId()
   mountGroup = entityManager.mountGroup()
   statusDir = mountGroup.mount( statusDirPath, 'Tac::Dir', 'ri' )
   mountGroup.close( callback=None )
