#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
import ShowCommand

from CliPlugin import EnvironmentCli, EnvironmentModels

from CliPlugin.FruCli import ModuleExpression

from CliToken.System import systemMatcherForShow

matcherCooling = CliMatcher.KeywordMatcher( 'cooling',
      helpdesc='Show system cooling status' )
matcherDetail = CliMatcher.KeywordMatcher( 'detail',
      helpdesc='Display detailed cooling information' )
matcherEnvironment = CliMatcher.KeywordMatcher( 'environment',
      helpdesc='Show system environment status' )
matcherModule = CliMatcher.KeywordMatcher( 'module',
      helpdesc='Show system temperature status for specific module' )
matcherTemperature = CliMatcher.KeywordMatcher( 'temperature',
      helpdesc='Show system temperature status' )
matcherTransceiver = CliMatcher.KeywordMatcher( 'transceiver',
      helpdesc='Show system temperature transceiver status' )

#--------------------------------------------------------------------------------
# show environment all
#--------------------------------------------------------------------------------
class EnvAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment all'
   data = {
      'environment' : matcherEnvironment,
      'all' : CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'all',
      helpdesc='Show all system environment status' ),
      deprecatedByCmd='show system environment all' ),
   }
   handler = EnvironmentCli.doShowEnvironmentAll

BasicCli.addShowCommandClass( EnvAllCmd )

#--------------------------------------------------------------------------------
# show environment temperature [ module ] [ detail ]
#--------------------------------------------------------------------------------
class EnvTemperatureCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment temperature [ module MODULE ] [ detail ]'
   data = {
      'environment' : matcherEnvironment,
      'temperature' : CliCommand.Node( matcher=matcherTemperature,
      deprecatedByCmd='show system environment temperature' ),
      'module' : matcherModule,
      'MODULE' : ModuleExpression, 
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowTemperature
   cliModel = EnvironmentModels.SystemTemperature

BasicCli.addShowCommandClass( EnvTemperatureCmd )

#--------------------------------------------------------------------------------
# show environment temperature transceiver [ module ] [ detail ]
#--------------------------------------------------------------------------------
class EnvTemperatureXcvrCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment temperature transceiver [ module MODULE ] [ detail ]'
   data = {
      'environment' : matcherEnvironment,
      'temperature' : CliCommand.Node( matcher=matcherTemperature,
      deprecatedByCmd='show system environment temperature' ),
      'transceiver' : matcherTransceiver,
      'module' : matcherModule,
      'MODULE' : ModuleExpression,
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowTemperatureXcvr
   cliModel = EnvironmentModels.SystemXcvrTemperature

BasicCli.addShowCommandClass( EnvTemperatureXcvrCmd )

#--------------------------------------------------------------------------------
# show environment cooling [ detail ]
#--------------------------------------------------------------------------------
class EnvCoolingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment cooling [ detail ]'
   data = {
      'environment' : matcherEnvironment,
      'cooling' : CliCommand.Node( matcher=matcherCooling,
      deprecatedByCmd='show system environment cooling' ),
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowCooling
   cliModel = EnvironmentModels.SystemCooling

BasicCli.addShowCommandClass( EnvCoolingCmd )

#--------------------------------------------------------------------------------
# show system environment all
#--------------------------------------------------------------------------------
class SystemEnvAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment all'
   data = {
      'system' : systemMatcherForShow,
      'environment' : matcherEnvironment,
      'all' : 'Show all environment status',
   }
   handler = EnvironmentCli.doShowEnvironmentAll

BasicCli.addShowCommandClass( SystemEnvAllCmd )

#--------------------------------------------------------------------------------
# show system environment cooling [ detail ]
#--------------------------------------------------------------------------------
class SystemEnvCoolingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment cooling [ detail ]'
   data = {
      'system' : systemMatcherForShow,
      'environment' : matcherEnvironment,
      'cooling' : matcherCooling,
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowCooling
   cliModel = EnvironmentModels.SystemCooling

BasicCli.addShowCommandClass( SystemEnvCoolingCmd )

#--------------------------------------------------------------------------------
# show system environment temperature [ module ] [ detail ]
#--------------------------------------------------------------------------------
class SystemEnvTemperatureCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment temperature [ module MODULE ] [ detail ]'
   data = {
      'system' : systemMatcherForShow,
      'environment' : matcherEnvironment,
      'temperature' : CliCommand.Node( matcher=matcherTemperature ),
      'module' : matcherModule,
      'MODULE' : ModuleExpression,
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowTemperature
   cliModel = EnvironmentModels.SystemTemperature

BasicCli.addShowCommandClass( SystemEnvTemperatureCmd )

#--------------------------------------------------------------------------------
# show system environment temperature transceiver [ module ] [ detail ]
#--------------------------------------------------------------------------------
class SystemEnvTemperatureXcvrCmd( ShowCommand.ShowCliCommandClass ):
   syntax = '''show system environment temperature transceiver
               [ module MODULE ] [ detail ]'''
   data = {
      'system' : systemMatcherForShow,
      'environment' : matcherEnvironment,
      'temperature' : CliCommand.Node( matcher=matcherTemperature ),
      'transceiver' : matcherTransceiver,
      'module' : matcherModule,
      'MODULE' : ModuleExpression,
      'detail' : matcherDetail,
   }
   handler = EnvironmentCli.doShowTemperatureXcvr
   cliModel = EnvironmentModels.SystemXcvrTemperature

BasicCli.addShowCommandClass( SystemEnvTemperatureXcvrCmd )

