# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliCommand
import CliMatcher

#-------------------------------------------------------------------------------
# 'tcp mss ceiling ([ipv4 <64-65495>] [ipv6 <64-65475>]) [ingress | egress ]' .
#-------------------------------------------------------------------------------
TcpMssConfig = Tac.Type( 'IpLib::TcpMssConfig' )

class CfgTcpMssCeilingCmdBase( CliCommand.CliCommandClass ):
   syntax = '''tcp mss ceiling { ( ipv4 MSS4 ) | ( ipv6 MSS6 ) }
               [ ingress | egress ]'''
   noOrDefaultSyntax = '''tcp mss ceiling ...'''
   _baseData = {
      'mss': 'Maximum segment size',
      'ceiling': 'Set maximum limit',
      'ipv4': CliCommand.singleKeyword( 'ipv4',
                                        helpdesc='Internet Protocol version 4' ),
      'MSS4': CliMatcher.IntegerMatcher( TcpMssConfig.tcpMssMin,
                                         TcpMssConfig.tcpMssMax4,
                                         helpdesc='Segment size' ),
      'ipv6': CliCommand.singleKeyword( 'ipv6',
                                        helpdesc='Internet Protocol version 6' ),
      'MSS6': CliMatcher.IntegerMatcher( TcpMssConfig.tcpMssMin,
                                         TcpMssConfig.tcpMssMax6,
                                         helpdesc='Segment size' ),
      'ingress': 'Enforce on packets arriving from the network',
      'egress': 'Enforce on packets forwarded to the network',
   }

   @staticmethod
   def _commonHandler( mode, args, ipv4Config, ipv6Config ):
      ipv4TcpMss = args.get( 'MSS4', [ 0 ] )[ 0 ]
      ipv6TcpMss = args.get( 'MSS6', [ 0 ] )[ 0 ]
      if 'ingress' in args:
         ipv4Config.maxMssIngress = ipv4TcpMss
         ipv6Config.maxMssIngress = ipv6TcpMss
         ipv4Config.maxMssEgress = 0
         ipv6Config.maxMssEgress = 0
      elif 'egress' in args:
         ipv4Config.maxMssIngress = 0
         ipv6Config.maxMssIngress = 0
         ipv4Config.maxMssEgress = ipv4TcpMss
         ipv6Config.maxMssEgress = ipv6TcpMss
      else: # Neither specified; set both.
         ipv4Config.maxMssIngress = ipv4TcpMss
         ipv6Config.maxMssIngress = ipv6TcpMss
         ipv4Config.maxMssEgress = ipv4TcpMss
         ipv6Config.maxMssEgress = ipv6TcpMss

   @staticmethod
   def _commonNoOrDefaultHandler( mode, ipv4Config, ipv6Config ):
      if ipv4Config:
         ipv4Config.maxMssIngress = 0
         ipv4Config.maxMssEgress = 0
      if ipv6Config:
         ipv6Config.maxMssIngress = 0
         ipv6Config.maxMssEgress = 0
