#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, TapAggPmapModel
from PolicyMapModelImpl import ActionBase
from TapAggPmapCliLib import tacStripHdrType

tacTapAggActionSetAggGroup = Tac.Type( 'TapAgg::TapAggActionSetAggGroup' )
tacTapAggActionSetIdentityTag = Tac.Type( 'TapAgg::TapAggActionSetIdentityTag' )
tacTapAggActionStripHdrBytes = Tac.Type( 'TapAgg::TapAggActionStripHeaderBytes' )

class TapAggGroupAction( object ):
   @classmethod
   def createModel( cls, groupVal ):
      model = TapAggPmapModel.TapAggGroupModel()
      model.actionType = groupVal.actionType
      model.aggGroup = groupVal.aggGroup.keys()
      model.aggIntf = groupVal.aggIntf.keys()
      return model

ActionBase.addActionType( tacTapAggActionSetAggGroup, TapAggGroupAction )

class TapAggIdTagAction( object ):
   @classmethod
   def createModel( cls, idTagVal ):
      model = TapAggPmapModel.TapAggIdTagModel()
      model.actionType = idTagVal.actionType
      model.idTag = idTagVal.idTag.outerVid
      model.innerIdTag = idTagVal.idTag.innerVid
      return model

ActionBase.addActionType( tacTapAggActionSetIdentityTag , TapAggIdTagAction )

class TapAggStripHdrAction( object ):
   @classmethod
   def createModel( cls, stripHdrVal ):
      model = TapAggPmapModel.TapAggStripHdrModel()
      model.actionType = stripHdrVal.actionType
      model.hdrType = stripHdrVal.stripHdrBytes.hdrType
      if model.hdrType == tacStripHdrType.dot1q:
         model.dot1qRemoveVlans = stripHdrVal.stripHdrBytes.dot1qRemoveVlans
      # Add handling for new header types here.
      return model

ActionBase.addActionType( tacTapAggActionStripHdrBytes, TapAggStripHdrAction )
