#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Int, Str, Enum
from CliModel import List
from IntfModels import Interface
from PolicyMapModel import ActionModel
from TapAggPmapCliLib import tacStripHdrType
import Intf.IntfRange

class TapAggGroupModel( ActionModel ):
   aggGroup = List( valueType=str,
            help="List of TapAgg Groups to flow the traffic ", optional=True)
   aggIntf = List( valueType=Interface,
            help="List of Tool Interfaces to flow the traffic", optional=True)

   def renderText( self ):
      if self.aggIntf:
         intfTypeList = Intf.IntfRange.intfListToCanonical( self.aggIntf )
         printIntfs = ','.join( intfTypeList )

      if self.aggGroup and self.aggIntf:
         return 'set group %s interface %s' % ( ','.join( sorted( self.aggGroup ) ),
                           printIntfs )
      elif self.aggGroup:
         return 'set group %s' % ','.join( sorted( self.aggGroup ) )
      else:
         return 'set interface %s' % printIntfs 

class TapAggIdTagModel( ActionModel ):
   idTag = Int( help='Id-tag value' )
   innerIdTag = Int( help='Inner id-tag value' )

   def renderText( self ):
      actionStr = 'set id-tag %d' % self.idTag
      if self.innerIdTag != 0:
         actionStr += ' inner %d' % self.innerIdTag
      return actionStr

class TapAggStripHdrModel( ActionModel ):
   hdrType = Enum( values=list(tacStripHdrType.attributes), help='Header type' )
   dot1qRemoveVlans = Str( help='VLAN indices to be removed' )
   # Add any info for the new header-types here.

   def renderText( self ):
      actionStr = ''
      if self.hdrType != tacStripHdrType.noStrip:
         actionStr += 'remove %s' % self.hdrType
         if self.hdrType == tacStripHdrType.dot1q:
            actionStr += ' outer %s' % self.dot1qRemoveVlans
         # Add handling for new header types here.
      return actionStr
