#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing
import PolicyMapCliLib

__defaultTraceHandle__ = Tracing.Handle( 'TapAggPmapCliLib' )
t0 = Tracing.trace0
t1 = Tracing.trace1
t9 = Tracing.trace9

tapAggIpAcls = 4096
tapAggMacAcls = 4096
tapAggMaxRules = tapAggIpAcls + tapAggMacAcls
tapAggMaxSequence = 0xFFFFFFFF
tapAggDefaultSeqInc = 10

tacActionType = Tac.Type( 'PolicyMap::ActionType' )
actSetAggregationGroup = tacActionType.setAggregationGroup
actSetIdentityTag = tacActionType.setIdentityTag
actStripHdrBytes = tacActionType.stripHeaderBytes

tacStripHdrType = Tac.Type( 'TapAgg::StripHeaderType' )
stripHdrNone = tacStripHdrType.noStrip
stripHdrDot1q = tacStripHdrType.dot1q

UniqueId = Tac.Type( 'Ark::UniqueId' )

aclConfig = None
ethLagIntfStatusDir = None
allIntfStatusDir = None

def stripHdrAction( hdrType, hdrInfo ):
   stripHdr = Tac.Value( 'TapAgg::StripHeaderInfo' )
   stripHdr.hdrType = hdrType
   if hdrType == stripHdrDot1q:
      stripHdr.dot1qRemoveVlans = hdrInfo
   # Add new strippable hdr-types here.
         
   return stripHdr

def removeActionFromTapAggActions( config, action ):
   actType = action.actionType
   actions = config.tapAggActions
   if actType == actSetAggregationGroup:
      del actions.aggGroup[ action.id ]
   elif actType == actSetIdentityTag:
      del actions.idTag[ action.id ]
   elif actType == actStripHdrBytes:
      del actions.stripHdrBytes[ action.id ]

class TapAggPolicyMapContext( PolicyMapCliLib.PolicyMapContext ):
   def __init__( self, config, statusReqDir, status, pmapName, pmapType ):
      PolicyMapCliLib.PolicyMapContext.__init__( self, config, statusReqDir, \
                     status, pmapName, pmapType )

   def defaultSequenceInc( self ):
      return tapAggDefaultSeqInc

   def maxRules( self ):
      return tapAggMaxRules 

   def removeAction( self, actionObj ):
      removeActionFromTapAggActions( self.config(), actionObj )

   # Function to remove groups from tapAggPmapConfig::group 
   # These groups are only those specified in Raw acl match in policy Maps
   def removeGroupsFromClass( self, seq ):
      #seq = self.lookupRuleToSeq( action )
      if not seq:
         return
      cmapName = self.npmap.classPrio.get( seq, None )
      groupKey = self.pmapName() + '_' + cmapName
      if groupKey in self.config().group.keys():
         del self.config().group[ groupKey ]
   
   def delRuleAtSeqnum( self, seqnum, clearActions=False ):
      self.removeGroupsFromClass( seqnum )
      PolicyMapCliLib.PolicyMapContext.delRuleAtSeqnum( self, seqnum,
                                                        clearActions=clearActions )

   def copyAction( self, src ):
      actionType = src.actionType
      actions = self.config().tapAggActions
      if actionType == actSetAggregationGroup:
         tapAggAct = actions.aggGroup.newMember( src.className, UniqueId() )
         for group in src.aggGroup:
            tapAggAct.aggGroup[ group ] = True
         for intf in src.aggIntf:
            tapAggAct.aggIntf[ intf ] = True
         tapAggAct.internalGroupName = src.internalGroupName
         return tapAggAct
      elif actionType == actSetIdentityTag:
         return actions.idTag.newMember( src.className, UniqueId(), src.idTag )
      elif actionType == actStripHdrBytes:
         action = actions.stripHdrBytes.newMember( src.className, UniqueId() )
         action.stripHdrBytes = src.stripHdrBytes
         return action
      return None

   def identicalClassActions( self, c1Action, c2Action ):
      c1ActTypes = c1Action.policyAction.keys()
      c2ActTypes = c2Action.policyAction.keys()
      if c1ActTypes != c2ActTypes:
         return PolicyMapCliLib.CHANGED
      for actType in c1ActTypes:
         if actType == actSetAggregationGroup:
            if ( c1Action.policyAction[ actType ].aggGroup.keys() != \
                  sorted( c2Action.policyAction[ actType ].aggGroup.keys() ) or
                  c1Action.policyAction[ actType ].aggIntf.keys() != \
                  sorted( c2Action.policyAction[ actType ].aggIntf.keys() ) or
                  c1Action.policyAction[ actType ].internalGroupName !=
                    c2Action.policyAction[ actType ].internalGroupName ):
               return PolicyMapCliLib.CHANGED
         elif ( actType == actSetIdentityTag):
            if ( c1Action.policyAction[ actType ].idTag !=
                 c2Action.policyAction[ actType ].idTag ):
               return PolicyMapCliLib.CHANGED
         elif actType == actStripHdrBytes:
            if c1Action.policyAction[ actType ].stripHdrBytes != \
                  c2Action.policyAction[ actType ].stripHdrBytes:
               return PolicyMapCliLib.CHANGED
      return PolicyMapCliLib.IDENTICAL

