#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import ConfigMount
import IntfCli
from Tracing import Handle, t0

__defaultTraceHandle__ = Handle( 'TagConfigCliPlugin' )

tagConfig = None

class TagCommand( CliCommand.CliCommandClass ):
   syntax = 'tag <TAGNAME>'
   noOrDefaultSyntax = 'tag [ <TAGNAME> ] ...'
   data = {
      'tag': CliMatcher.KeywordMatcher(
         'tag',
         helpdesc='Configure Tag for the interface' ),
      '<TAGNAME>': CliMatcher.PatternMatcher( pattern=r'[A-Za-z0-9_-]+',
                                              helpname="WORD",
                                              helpdesc="Tag name" ),
   }

   @staticmethod
   def handler( mode, args ):
      tagName = args[ '<TAGNAME>' ]
      intfName = mode.intf.name
      if not tagName:
         t0( "Did not find tag name for", intfName )
         return
      else:
         t0( "Configured %s for %s" % ( tagName, intfName ) )
         if not tagConfig.intfConfig.has_key( intfName ):
            tagConfig.newIntfConfig( intfName )
         intfConfig = tagConfig.intfConfig[ intfName ]
         if len( intfConfig.tag ) == intfConfig.maxTags:
            if tagName not in intfConfig.tag:
               mode.addError( "Maximum of %d tags are configurable on an interface"
                                 % intfConfig.maxTags )
         intfConfig.tag[ tagName ] = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      tagName = args.get( '<TAGNAME>' )
      intfName = mode.intf.name
      if tagConfig.intfConfig.has_key( intfName ):
         intfConfig = tagConfig.intfConfig[ intfName ]
         if tagName:
            del intfConfig.tag[ tagName ]
         else:
            intfConfig.tag.clear()
         if not tagConfig.intfConfig[ intfName ].tag:
            del tagConfig.intfConfig[ intfName ]

IntfCli.IntfConfigMode.addCommandClass( TagCommand )

class TagIntfCleaner( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      del tagConfig.intfConfig[ self.intf_.name ]

#------------------------------------------------------
# Plugin method
#------------------------------------------------------

def Plugin( em ):
   global tagConfig
   tagConfig = ConfigMount.mount( em, "tag/config", "Tag::Config", "w" )
   IntfCli.Intf.registerDependentClass( TagIntfCleaner )
