#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.PulseCli as PulseCli
from CliPlugin.PulseCliModel import Match
from CliToken.Debugging import debuggingMatcherForShow

#--------------------------------------------------------------------------------
# show debugging counter { COUNTERNAME }
#--------------------------------------------------------------------------------
class DebuggingCounterCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging counter { COUNTERS }'
   data = {
      'debugging' : debuggingMatcherForShow,
      'counter' : 'Print the value of a single counter',
      'COUNTERS' : CliMatcher.PatternMatcher( pattern=\
      r'[A-Za-z0-9_:{}\[\]-]+/[A-Za-z0-9_:{}\[\]-]+',\
      helpdesc='The full name of a counter', helpname='TABLE/COUNTER' ),
   }
   handler = PulseCli.printCounter
   cliModel = Match
   privileged = True

BasicCli.addShowCommandClass( DebuggingCounterCmd )

#--------------------------------------------------------------------------------
# show debugging counters [ MATCHNAME ]
#--------------------------------------------------------------------------------
class DebuggingCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging counters [ MATCHNAME ]'
   data = {
      'debugging' : debuggingMatcherForShow,
      'counters' : 'Print all the matching counters',
      'MATCHNAME' : CliMatcher.PatternMatcher( pattern=\
      r'[A-Za-z0-9_:{}\[\]-]*/?[A-Za-z0-9_:{}\[\]-]*',\
      helpdesc='The partial name of a counter to search for', helpname='NAME' ),
   }
   handler = PulseCli.printMatches
   cliModel = Match
   privileged = True

BasicCli.addShowCommandClass( DebuggingCountersCmd )
