# Copyright (c) 2009 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the SwitchIntf type.
# This class is used by the L2 querier as a logical representation
# to an "internal switch interface" through which the l2 querier magically
# operates.
#-------------------------------------------------------------------------------
import CliMatcher

class SwitchIntf( object ):
   # pylint complains that we use a lambda which is just wrapping a
   # bare function of the same arguments, but in this case (because
   # the class name isn't yet in scope) the alternatives are all less
   # readable than using a lambda.
   # pylint: disable-msg=W0108

   #----------------------------------------------------------------------------
   # Creates a new SwitchIntf instance of the specified name.
   #----------------------------------------------------------------------------
   def __init__( self, _mode, _match ):
      self.name  = 'Switch'

   #----------------------------------------------------------------------------
   # The rule for matching Switch interface name.  When this pattern matches, it
   # returns an instance of the SwitchIntf class.
   #
   # This rule is currently not added to the Intf.rule, which is usually done
   # by a call to Intf.addPhysicalIntfType
   #----------------------------------------------------------------------------
   matcher = CliMatcher.KeywordMatcher(
            'Switch',
            value=lambda mode, match: SwitchIntf( mode, match ),
            helpdesc='Internal switch interface' )
