# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
import Tac, Tracing, Cell, LazyMount
import BasicCliUtil
from Fru import slotId
import FileReplicationCmds
from issh import issh

__defaultTraceHandle__ = Tracing.Handle( "SupeSessionCli" )
t0 = Tracing.trace0

electionStatus = None

#--------------------------------------------------------------
# session peer-supervisor [ CMD ]
#--------------------------------------------------------------
@BasicCliUtil.EapiIncompatible()
def runCliOnPeerSupe( mode, args ):
   if electionStatus.redundancyMode != 'active':
      mode.addError( "Command is unavailable on this supervisor" )
      return

   if electionStatus.peerState == 'notInserted' or \
         electionStatus.peerState == 'powerdOff':
      mode.addError( "Peer supervisor is unavailable" )
      return

   argv = [ issh(),
            '-l', 'sessionuser',
            FileReplicationCmds.peerAddress[ slotId() ] ]
   if 'CMD' in args:
      argv += args.get( 'CMD', '' ).split()

   try:
      Tac.run( argv, stdin=sys.stdin, stdout=sys.stdout )
      # To print the prompt in the next line when user hits ^D on the peer sup CLI
      print ""
   except Tac.SystemCommandError:
      mode.addError( "Peer connection failed" )

def Plugin( entityManager ):
   global electionStatus
   electionStatus = LazyMount.mount( entityManager,
                                     Cell.path( 'redundancy/election/status' ),
                                    'Election::Status', 'r' )
