# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import StpCli
import LazyMount 
from StpCliUtil import loopGuardCliGuard, hwEpochStatusIs

configMode = BasicCli.GlobalConfigMode

#-------------------------------------------------------------------------------
# [no] spanning-tree guard loop default
#
# legacy:
# [no] spanning-tree loopguard default
#-------------------------------------------------------------------------------

# To set the global default for all interfaces to 'enable' 
# type 'spanning-tree guard loop default' 
# To set the global default for all interfaces to 'disable' 
# type 'no spanning-tree guard loop default' 
# Ports can be individually configured, but unconfigured ports 
# will revert to the global default

loopguardNodeDeprecated = CliCommand.Node(
      matcher = CliMatcher.KeywordMatcher(
         'loopguard',
         helpdesc='Spanning tree loopguard options' ),
      guard=loopGuardCliGuard,
      deprecatedByCmd='spanning-tree guard loop default' )

guardNode = CliCommand.Node( 
      matcher = CliMatcher.KeywordMatcher(
         'guard',
         helpdesc='Spanning tree loopguard options' ),
      guard=loopGuardCliGuard )

class SpanningTreeGlobalLoopGuard( CliCommand.CliCommandClass ):
   syntax = 'spanning-tree ( loopguard | ( guard loop ) ) default'
   noOrDefaultSyntax = syntax
   data = {
      'spanning-tree': 'Spanning tree protocol',
      'loopguard': loopguardNodeDeprecated,
      'guard': guardNode,
      'loop': 'Spanning tree loopguard options',
      'default': 'Enable loopguard by default on all ports'
   }

   @staticmethod
   def handler( mode, args ):
      StpCli.stpInputConfig().loopGuardEnabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      config = StpCli.stpInputConfig()
      config.loopGuardEnabled = config.loopGuardEnabledDefault

configMode.addCommandClass( SpanningTreeGlobalLoopGuard )

def Plugin( entityManager ):
   hwEpochStatus = LazyMount.mount( entityManager, "hwEpoch/status",
                                    "HwEpoch::Status", "r" )
   hwEpochStatusIs( hwEpochStatus )

