#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# The point of this library is to hold shareable tokens and sequences of
# tokens for the spanning tree cli.  It is installed as a CliPlugin so that
# it can import the VlanCli and IntfCli plugins.

import CliPlugin.EbraEthIntfCli as EbraEthIntfCli
import CliPlugin.VirtualIntfRule as VirtualIntfRule
from StpCliUtil import *

#-------------------------------------------------------------------------------
# Register the EthLagIntf class as able to participate in interface ranges.
#-------------------------------------------------------------------------------

# This rule is used to match an interface name for Stp commands such as
# "show spanning-tree interface <intf name>.  A CliPlugin provided by
# another package can add to this rule if that package introduces new
# interface types on which Stp is active.  For example, Mlag introduces
# interfaces named Peer(Ethernet|Port-Channel)XX.
stpIntfMatcher = VirtualIntfRule.IntfMatcher()
stpIntfMatcher |= EbraEthIntfCli.switchPortMatcher
