#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliParser
import CliPlugin.StorageDevicesCli as StorageDevicesCli
import CliToken.Reset
import CliToken.System

# Only supported on Arista hardware
def platformGuard( mode, token ):
   cmdline = open( "/proc/cmdline" ).read()
   unsupportedPlatforms = [ "onie_platform=", "platform=baremetal",
                            "platform=dropbear", "platform=veos" ]
   for platform in unsupportedPlatforms:
      if platform in cmdline:
         return CliParser.guardNotThisPlatform
   return None

#--------------------------------------------------------------------------------
# reset system storage [secure]
#--------------------------------------------------------------------------------
class ResetStorage( CliCommand.CliCommandClass ):
   syntax = "reset system storage secure"
   data = {
         'reset': CliToken.Reset.resetKwApi,
         'system': CliToken.System.systemMatcherForResetSystem,
         'storage': CliCommand.Node(
                       matcher=CliMatcher.KeywordMatcher( 'storage',
                          helpdesc="reset storage devices" ),
                       guard=platformGuard ),
         'secure' : "Secure erase, then repartition and "
                    "reformat crash:, drive:, and flash: "
                    "(as applicable)"
   }
   handler = StorageDevicesCli.resetSystemStorage
BasicCli.EnableMode.addCommandClass( ResetStorage )
